// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "emutime.h"
#include "ini.h"
#include "hw_emutime.h"

//static DWORD *rtcf = &g::rtcf;

//D=DWORD
//Q=QWORD
//U=Upper DWORD
//L=Lower DWORD
//W=WORD

//I'd like to use templates here, but they won't work with assembly.
//Don't forget the return address, which is pushed after all arguments.

//QWORD arguments are passed on stack. highword is pushed first, get it from [esp+8].
//get loword from [esp+4].
//if you haven't pushed anything before, that is. then you'll have to recalculate.

//Smaller ones are passed in registers even if there's a qword before them.

//Says MSDN: "The compiler generates prolog and epilog code to save and restore
//  the ESI, EDI, EBX, and EBP registers, if they are used in the function."
//I think that means that I can use all other registers without saving them.

#define DEFINE_MULDIV_DDDQ(name, factor1, factor2, divisor)\
	__declspec(naked) QWORD __fastcall name(DWORD /*factor1*/) { __asm {\
	__asm push ebx\
	__asm push esi\
	__asm push edi\
	__asm mov eax, factor2\
	__asm mov edi, divisor\
	__asm mul ecx\
	__asm mov ebx, eax\
	__asm mov eax, edx\
	__asm xor edx, edx\
	__asm div edi\
	__asm mov esi, eax\
	__asm mov eax, ebx\
	__asm div edi\
	__asm mov edx, esi\
	__asm pop edi\
	__asm pop esi\
	__asm pop ebx\
	__asm ret\
} }
DEFINE_MULDIV_DDDQ(TB_2_RTC, tb, g::rtcf, TB_PER_S)

#define DEFINE_MUL_DDQ(name, factor1, factor2)\
	__declspec(naked) QWORD __fastcall name(DWORD /*factor1*/) { __asm {\
	__asm mov eax, factor2\
	__asm mul ecx\
	__asm ret\
} }
DEFINE_MUL_DDQ(TB_2_CYCLES, tb, (BOGOMIPS/TB_PER_S))

#define DEFINE_DIV_QDU(name, dividend, divisor)\
	__declspec(naked) DWORD __fastcall name(QWORD /*dividend*/) { __asm {\
	__asm mov eax, [esp+8]\
	__asm mov ecx, divisor\
	__asm xor edx, edx\
	__asm div ecx\
	__asm ret 8\
} }
DEFINE_DIV_QDU(CYCLES_2_TBU, cycles, (BOGOMIPS/TB_PER_S))

#define DEFINE_DIV_QDL(name, dividend, divisor)\
	__declspec(naked) DWORD __fastcall name(QWORD /*dividend*/) { __asm {\
	__asm mov eax, [esp+8]\
	__asm mov ecx, divisor\
	__asm xor edx, edx\
	__asm div ecx\
	__asm mov eax, [esp+4]\
	__asm div ecx\
	__asm ret 8\
} }
DEFINE_DIV_QDL(CYCLES_2_TBL, cycles, (BOGOMIPS/TB_PER_S))

#define DEFINE_MULDIV_QDDU(name, factor1, factor2, divisor)\
	__declspec(naked) DWORD __fastcall name(QWORD /*factor1*/) { __asm {\
	__asm push esi\
	__asm push edi\
	__asm mov eax, [esp+16]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart*/\
	__asm mov edi, edx  /*highpart*/\
	__asm mov eax, [esp+12]\
	__asm mul ecx	/*now we must add everything together, edi:esi: and :edx:eax.*/\
	__asm mov ecx, divisor\
	__asm add esi, edx\
	__asm adc edi, 0  /*now product is in edi:esi:eax */\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm div ecx\
	__asm mov eax, esi\
	__asm div ecx\
	__asm pop edi\
	__asm pop esi\
	__asm ret 8\
} }
DEFINE_MULDIV_QDDU(RTC_2_TBU, rtc, TB_PER_S, g::rtcf)

#define DEFINE_MULDIV_QDDL(name, factor1, factor2, divisor)\
	__declspec(naked) DWORD __fastcall name(QWORD /*factor1*/) { __asm {\
	__asm push ebx\
	__asm push esi\
	__asm push edi\
	__asm mov eax, [esp+20]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart*/\
	__asm mov edi, edx  /*highpart*/\
	__asm mov eax, [esp+16]\
	__asm mul ecx	/* now we must add everything together, edi:esi: and :edx:eax.*/\
	__asm mov ecx, divisor\
	__asm add esi, edx\
	__asm adc edi, 0\
	__asm mov ebx, eax  /* now product is in edi:esi:ebx */\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm div ecx\
	__asm mov eax, esi\
	__asm div ecx\
	__asm mov eax, ebx\
	__asm div ecx\
	__asm pop edi\
	__asm pop esi\
	__asm pop ebx\
	__asm ret 8\
} }
DEFINE_MULDIV_QDDL(RTC_2_TBL, rtc, TB_PER_S, g::rtcf)
DEFINE_MULDIV_QDDL(RTC_2_MS, rtc, 1000, g::rtcf)

#define DEFINE_MULDIV_QDDLW(name, factor1, factor2, divisor)\
	__declspec(naked) WORD __fastcall name(QWORD /*factor1*/) { __asm {\
	__asm push ebx\
	__asm push esi\
	__asm push edi\
	__asm mov eax, [esp+20]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart*/\
	__asm mov edi, edx  /*highpart*/\
	__asm mov eax, [esp+16]\
	__asm mul ecx	/* now we must add everything together, edi:esi: and :edx:eax.*/\
	__asm mov ecx, divisor\
	__asm add esi, edx\
	__asm adc edi, 0\
	__asm mov ebx, eax  /* now product is in edi:esi:ebx */\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm div ecx\
	__asm mov eax, esi\
	__asm div ecx\
	__asm mov eax, ebx\
	__asm div ecx\
	__asm and eax, 0xFFFF\
	__asm pop edi\
	__asm pop esi\
	__asm pop ebx\
	__asm ret 8\
} }
DEFINE_MULDIV_QDDLW(RTC_2_LENGTH_32, rtc, 32000/8, g::rtcf)
DEFINE_MULDIV_QDDLW(RTC_2_LENGTH_48, rtc, 48000/8, g::rtcf)

#define DEFINE_DIV_QDLW(name, dividend, divisor)\
	__declspec(naked) WORD __fastcall name(QWORD /*dividend*/) { __asm {\
	__asm mov ecx, divisor\
	__asm mov eax, [esp+8]\
	__asm xor edx, edx\
	__asm div ecx\
	__asm mov eax, [esp+4]\
	__asm div ecx\
	__asm and eax, 0xFFFF\
	__asm ret 8\
} }
DEFINE_DIV_QDLW(CYCLES_2_LENGTH_32, cycles, BOGOMIPS/(32000/8))
DEFINE_DIV_QDLW(CYCLES_2_LENGTH_48, cycles, BOGOMIPS/(48000/8))

DEFINE_MULDIV_DDDQ(LENGTH_2_RTC_32, length, g::rtcf, 32000/8)
DEFINE_MULDIV_DDDQ(LENGTH_2_RTC_48, length, g::rtcf, 48000/8)
DEFINE_MUL_DDQ(LENGTH_2_CYCLES_32, length, BOGOMIPS/(32000/8))
DEFINE_MUL_DDQ(LENGTH_2_CYCLES_48, length, BOGOMIPS/(48000/8))

DEFINE_MULDIV_QDDL(RTC_2_AISCNT, rtc, 48000, g::rtcf)
DEFINE_DIV_QDL(CYCLES_2_AISCNT, cycles, BOGOMIPS/48000)
DEFINE_MULDIV_DDDQ(AISCNT_2_RTC, aiscnt, g::rtcf, 48000)
DEFINE_MUL_DDQ(AISCNT_2_CYCLES, length, BOGOMIPS/48000)

/*struct VIFRAME {
ULI rawframe;	//((time*LINES_PER_SECOND)/freq)/LINES_PER_FRAME
WORD newline;	//((time*LINES_PER_SECOND)/freq)%LINES_PER_FRAME + 1
};*/

#define DEFINE_MULDIVDIV_QDDD_VIFRAMEP(name, factor1, factor2, divisor1, divisor2,\
	pointer)\
	__declspec(naked) void __fastcall name(QWORD /*factor1*/, VIFRAME* /*pointer*/)\
{ __asm {\
	__asm push ebx\
	__asm push esi\
	__asm push edi\
	__asm push ecx  /*pointer*/\
	__asm mov eax, [esp+24]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart*/\
	__asm mov edi, edx  /*highpart*/\
	__asm mov eax, [esp+20]\
	__asm mul ecx	/* now we must add everything together, edi:esi: and :edx:eax.*/\
	__asm mov ecx, divisor1\
	__asm add esi, edx\
	__asm adc edi, 0\
	__asm mov ebx, eax  /* now product is in edi:esi:ebx */\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm div ecx\
	__asm mov edi, eax\
	__asm mov eax, esi\
	__asm div ecx\
	__asm mov esi, eax\
	__asm mov eax, ebx\
	__asm div ecx\
	__asm mov ebx, eax\
	__asm mov ecx, divisor2\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm pop edi	/*pointer*/\
	__asm div ecx\
	__asm mov eax, esi\
	__asm div ecx\
	__asm mov [edi+4], eax\
	__asm mov eax, ebx\
	__asm div ecx\
	__asm mov [edi], eax\
	__asm mov [edi+8], dx\
	__asm pop edi\
	__asm pop esi\
	__asm pop ebx\
	__asm ret 8\
} }
DEFINE_MULDIVDIV_QDDD_VIFRAMEP(RTC_2_VIFRAME_PAL, rtc, 25*625, g::rtcf, 625, vif)
DEFINE_MULDIVDIV_QDDD_VIFRAMEP(RTC_2_VIFRAME_NTSC, rtc, 30*525, g::rtcf, 525, vif)
DEFINE_MULDIVDIV_QDDD_VIFRAMEP(CYCLES_2_VIFRAME_PAL, cycles, 25*625, BOGOMIPS, 625, vif)
DEFINE_MULDIVDIV_QDDD_VIFRAMEP(CYCLES_2_VIFRAME_NTSC, cycles, 30*525, BOGOMIPS, 525, vif)

#define DEFINE_MULDIV_QDDQ(name, factor1, factor2, divisor)\
	__declspec(naked) QWORD __fastcall name(QWORD /*factor1*/) { __asm {\
	__asm push ebx\
	__asm push esi\
	__asm push edi\
	__asm mov eax, [esp+20]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart*/\
	__asm mov edi, edx  /*highpart*/\
	__asm mov eax, [esp+16]\
	__asm mul ecx	/* now we must add everything together, edi:esi: and :edx:eax.*/\
	__asm mov ecx, divisor\
	__asm add esi, edx\
	__asm adc edi, 0\
	__asm mov ebx, eax  /* now product is in edi:esi:ebx */\
	__asm xor edx, edx\
	__asm mov eax, edi\
	__asm div ecx\
	__asm mov eax, esi\
	__asm div ecx\
	__asm mov edi, eax\
	__asm mov eax, ebx\
	__asm div ecx\
	__asm mov edx, edi\
	__asm pop edi\
	__asm pop esi\
	__asm pop ebx\
	__asm ret 8\
} }
DEFINE_MULDIV_QDDQ(RAWFRAME_2_RTC_PAL, rawframe, g::rtcf, 25)
DEFINE_MULDIV_QDDQ(RAWFRAME_2_RTC_NTSC, rawframe, g::rtcf, 30)

DEFINE_MULDIV_DDDQ(LINES_2_RTC_PAL, rawframe, g::rtcf, 25)
DEFINE_MULDIV_DDDQ(LINES_2_RTC_NTSC, rawframe, g::rtcf, 30)
DEFINE_MULDIV_DDDQ(LINES_2_CYCLES_PAL, rawframe, BOGOMIPS, 25)
DEFINE_MULDIV_DDDQ(LINES_2_CYCLES_NTSC, rawframe, BOGOMIPS, 30)

#define DEFINE_MUL_QDQ(name, factor1, factor2)\
	__declspec(naked) QWORD __fastcall name(QWORD /*factor1*/) { __asm {\
	__asm push esi\
	__asm mov eax, [esp+12]\
	__asm mov ecx, factor2\
	__asm mul ecx\
	__asm mov esi, eax  /*midpart. we don't care about the highpart.*/\
	__asm mov eax, [esp+8]\
	__asm mul ecx	/* now we must add everything together, esi: and edx:eax.*/\
	__asm add edx, esi\
	__asm pop esi\
	__asm ret 8\
} }
DEFINE_MUL_QDQ(RAWFRAME_2_CYCLES_PAL, rawframe, BOGOMIPS/25)
DEFINE_MUL_QDQ(RAWFRAME_2_CYCLES_NTSC, rawframe, BOGOMIPS/30)
